# Copy Plan to Baseline
# Copyright 2008 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 080516 - first draft of this script

debug = 0

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def CopyPlan(self):
    dp = Data.Database['Project']
    dt = Data.Database['Task']

    reportid = self.ReportID  # current report
    pid = Data.Database['Report'][reportid].get('ProjectID')
    if pid not in dp: return

    tasks = Data.SearchByColumn(dt, {'ProjectID': pid})
    for k, v in tasks.iteritems():
        if v.get('zzStatus') == 'deleted': continue
        if v.get('SubtaskCount'):
            start_date, start_hour, end_date, end_hour, effort_hours = None
        else:
            start_date = v.get('CalculatedStartDate')
            start_hour = v.get('CalculatedStartHour')
            end_date = v.get('CalculatedEndDate')
            end_hour = v.get('CalculatedEndHour')
            effort_hours = v.get('EffortHours')
        change = {'Table': 'Task',
                  'ID': k,
                  'BaseStartDate': start_date,
                  'BaseStartHour': start_hour,
                  'BaseEndDate': end_date,
                  'BaseEndHour': end_hour,
                  'BaseEffortHours': effort_hours,
                 }
        Data.Update(change)

    Data.SetUndo('Copy Plan to Baseline')

CopyPlan(self)
